//  
quizFileName = "iscript/quiz/quiz1.txt";

// -   
quizQuestionCount = 3;

//    ()
quizAnswerPeriod = 20000;





function LoadQuiz(fileName)
{
    var quiz = array();
    var f = fopen(fileName,"rb");
    if (!f) { print("Can't open file!\n"); return; }
    var line = '';
    while(!feof(f))
    {
        while(!feof(f))
        {
            if (startwith(line, ":")) break;
            line = fgets(f);
        }
        
        if (!startwith(line, ":")) break;
        
        var question = object();
        array_push(quiz, question);
                    
        var text = '';
        while(!feof(f))
        {
            line = trim(fgets(f));
            if (line=='') continue;
            if (startwith(line, ":") ||startwith(line, ":")) break;
            if (text!='') text+=' ';
            text+=line;
        }

        question.question = text;
        question.used=false;
        question.answers = array();
        question.desc = '';
        while(!feof(f))
        {
           line = trim(fgets(f));
           if (line=='') continue;
           if (startwith(line, ":")) break;
           if (startwith(line, ":")) break;
           if (startwith(line, "--")) break;
           array_push(question.answers, line);
        }

        if (startwith(line, ":") ||
            startwith(line, ":"))
        {
            text = '';
            while(!feof(f))
            {
                line = trim(fgets(f));
                if (line=='') continue;
                if (startwith(line, ":") || startwith(line, "--")) break;
                if (text!='') text+=' ';
                text+=line;
            }
            question.desc = text;
        }
    }
    fclose(f);
    return quiz;
}


function Quiz()
{
	var quiz = LoadQuiz(quizFileName);

	SetBrowserURL('quiz.html');

	PlayWave("iscript/quiz/intro.mp3");
	Sleep(6000);

	if (quiz.length < quizQuestionCount)
	{
		Say(",     ");
		return;
	}

	var rightAnswers = 0;

	SpeechRecognizer(true);
	FaceRecognizer(false);
	quizMode = true;
	for(var n=0; n < quizQuestionCount; n++)
	{
		//   ,    ,   
		var q;
		do
		{
			q = rand(quiz.length);
		} while(quiz[q].used);

        
        quiz[q].used = true;


		if (n > 0)
		{
			Say(",  ",
				",  ",
				" ");
		}
		else
		{
			Say(" ",
				" ");
		}

		while(Say()) sync();
		PlayWave("iscript/quiz/gong.mp3");
		Sleep(2000);

		Say(quiz[q].question);

		while(Say()) sync();
		if (!quizMode) return;


		var startT = GetTickCount();
		PlayWave("iscript/quiz/clock.mp3");
		Say("","  ");


		gAnswer = false;
		DeleteFrameset("quiz222");
		CreateFrameset("quiz222", 2);
		for(var i=0; i < quiz[q].answers.length; i++)
		{
			CreateFrame(quiz[q].answers[i],	"gAnswer=true;");
		}

		while(GetTickCount() - startT < quizAnswerPeriod)
		{
			sync();
			if (!quizMode) break;
			if (gAnswer)
			{
				PlayWave(false);
				break;
			}
		}

		DeleteFrameset("quiz222");
		if (!quizMode) return;

		if (gAnswer)
		{
			PlayWave("iscript/quiz/correct.mp3");
			Sleep(800);
			Say(" ,  "+ quiz[q].answers[0],
				", "+quiz[q].answers[0],
				"  , "+quiz[q].answers[0]);
			rightAnswers++;
		}
		else
		{
			Say("   .  , "+quiz[q].answers[0],
				" .  , "+quiz[q].answers[0],
				"   .   , "+quiz[q].answers[0]);
		}
		while(Say()) sync();
		if (!quizMode) return;

		if (quiz[q].desc!='')
		{
		    Sleep(300);
		    Say(quiz[q].desc);
		    while(Say()) sync();
		}
		Sleep(1000);
		if (!quizMode) return;
	}

	if (rightAnswers == quizQuestionCount)
	{
		Say("  , ,      ",
			" ,      ");
	}
	else
	{
		Say("  ,    "+rightAnswers+" "+WordCase(rightAnswers,"","","")+"  "+NumberToDesc(quizQuestionCount,""));
	}
	while(Say()) sync();
	Say("     .   ");
	while(Say()) sync();
	quizMode = false;
	FaceRecognizer(true);
	SetBrowserURL('index.html');
}


quizMode = false;
frameset("quiz",3)
{
	frame("   ")
	{
		if (quizMode)
		{
			PlaySpeech("  ");
			return;
		}
		SetTaskPrior(1);
		Say("(G:|),  ");
		while(Say()) sync();
		Quiz();
	}
	frame("|||||||| ")
	{
		if (!quizMode)
		{
			PlaySpeech("    ");
			return;
		}
		PlayWave(false);
		FaceRecognizer(true);
		SetBrowserURL('index.html');
		Say("(G:|),  ");
		quizMode=false;
	}
}	
