frameset("currencies")
{
	frame("|||||")
	frame(" & |&| & | & | & | & ")
	frame(" & | & | & ") { return "|RUB"; }

	frame("||||  &  | | &  | & |  &  |  & | & | & | & ") { return "|USD"; }
	frame("") { return "|EUR"; }
	frame("|||| & | & | & | & | & | & | & | & ") { return "|UAH"; }
	frame(" & | & | & | & | & | & ") { return "|CHF"; }

	frame("|||| & | & | & || & | & | & ") { return "|CNY"; }
	frame(" | &| &| & | & | &  |  & |  &  | &  |  & | & |  & ") { return "|BYN"; }

	frame("|||| [  ]")
	frame(" & | & | & | & | & | & ")
	frame(" & | & | & | & | & | & ") { return "|GBP"; }
}


currencyRates = null;
currencyDateReq = "";


function GetCurrencyRates()
{
	var tm = localtime(time());
	var d = toString(tm.day); if (strlen(d) < 2) d = "0"+d;
	var m = toString(tm.month); if (strlen(m) < 2) m = "0"+m;
	var y = toString(tm.year);
	var date_req = d+"/"+m+"/"+y;
	if (date_req!=currencyDateReq)
	{
		if (!IsInternet())
		{
			PlaySpeech("      .   ",
			"      .    ,   .   ,    ");
			return false;
		}

		PlaySpeech("","",",  ",",  ");

		HTTPEncoding("windows-1251");
		currencyRates = HttpRequestXML("http://www.cbr.ru/scripts/XML_daily.asp?date_req="+date_req);
		HTTPEncoding("UTF-8");
		if (!currencyRates)
		{
			print("Can't download xml-file!\n");
			currencyDateReq = "";
			PlaySpeech("  (R:||)  .   ");
			return false;
		}
		else
			currencyDateReq = date_req;
	}
	return true;
}

function GetRateOf(charCode)
{
	print("charCode=",charCode,"\n");
	if (charCode=="RUB")
	{
		var obj = object();
		obj.nominal = 1;
		obj.rate = 1.0;
		obj.name = "";
		return obj;
	}

	if (!GetCurrencyRates()) return null;

	show(currencyRates, "_currency.xml");

	if (currencyRates.tagName == "ValCurs")
	{
		for(var i=0; i < count(currencyRates.children); i++)
		{
			var valuteTag = currencyRates.children[i];
			
			if (valuteTag.tagName == "Valute")
			{
				var found = false;
				for(var j=0; j < count(valuteTag.children); j++)
				{
					if (valuteTag.children[j].tagName=="CharCode")
					{
						if (valuteTag.children[j].text == charCode)
						{
							found = true;
							break;
						}
					}
				}

				if (found)
				{
					var obj = object();
					for(var j=0; j < count(valuteTag.children); j++)
					{
						if (valuteTag.children[j].tagName=="Nominal")
						{
							obj.nominal = toInt(valuteTag.children[j].text);
						}
						else
						if (valuteTag.children[j].tagName=="Value")
						{
							obj.rate = toFloat(replace(valuteTag.children[j].text, ",",  "."));
						}
						else
						if (valuteTag.children[j].tagName=="Name")
						{
							obj.name = valuteTag.children[j].text;
						}
					}
					return obj;
				}
				
			}
		}
	}
	PlaySpeech("      ");
	return null;
}

function SayRateOf(charCode)
{
	var obj = GetRateOf(charCode);
	if (!obj) return;
	PlaySpeech(" "+NumberToDesc(obj.nominal)+" "+obj.name+"  "+ValuteToDesc(obj.rate,"",true));
}


function SayValuteToValute(sum, from, to)
{
	var fromObj = GetRateOf(from);
	if (!fromObj) return;

	var toObj = GetRateOf(to);
	if (!toObj) return;

	var rub = sum * fromObj.rate / fromObj.nominal;
	var n = rub / toObj.rate * toObj.nominal;

	PlaySpeech(ValuteToDesc(sum, fromObj.name)+",  "+ValuteToDesc(n, toObj.name));
}



frameset("currencies2",1)
{
	frame("   & | & | & ")
	frame(" | |  &  |  &  |  & ")
	{
		PlaySpeech("   ?"," ,    >>");
		while(PlaySpeech()) sync();
		frameset("temp",1)
		{
			frame("  <valute:currencies>")
			frame("<valute:currencies>")
			{
				LangQuery("   "+TextOf("valute"));
			}
		}
		
	}

	frame("  <valute:currencies>")
	frame("   <valute:currencies>")
	frame("//// []  <valute:currencies>")
	frame(" [] | [] <valute:currencies>")
	frame(" |  [] <valute:currencies>")
	{
		var pair = split("|",ValueOf("valute"));
		SayRateOf(pair[1]);
		frameset("temp",1)
		{
			frame(" <valute:currencies>")
			{
				LangQuery("   "+TextOf("valute"));
			}
		}
	}

	frame("<sum:digits> <from:currencies>    ")
	frame("<sum:digits> <from:currencies>  :")
	{
		var fromPair = split("|",ValueOf("from"));
		var sum = toFloat(TextOf("sum"));
		SayValuteToValute(sum, fromPair[1], "RUB");
	}

	frame("<sum:digits> <from:currencies>    <to:currencies>")
	frame("<sum:digits> <from:currencies>    <to:currencies>")
	frame(" <sum:digits> <from:currencies>  <to:currencies>")
	{
		var fromPair = split("|",ValueOf("from"));
		var toPair = split("|",ValueOf("to"));
		var sum = toFloat(TextOf("sum"));
		SayValuteToValute(sum, fromPair[1], toPair[1]);
	}
}

frameset("robotCurrencies",1)
{
	frame("<r:robotName> <a:currencies2>")
	{
		ValueOf("a");
	}
}

IsInternet();