const longKeyWidth = 120;
const veryLongKeyWidth=160;
const spaceKeyWidth=1000;

function __virtual_keyboard_key_onmousedown()
{
	this.setDown(true);
	virtualKeyboard.onKey(this);
}

function __virtual_keyboard_key_touchstart(e)
{
	e.preventDefault();
	this.setDown(true);
	virtualKeyboard.onKey(this);
}

function __virtual_keyboard_key_onmouseup()
{
	if (!this.fixDown) this.setDown(false);
}

function __virtual_keyboard_key_set_down(onOff)
{
	this.down = onOff;
	this.className = onOff ? "virtualKeyboardKeyDown":"virtualKeyboardKey";
}

function __virtual_keyboard_key_set_fix_down(onOff)
{
	this.fixDown = onOff;
	this.setDown(onOff);
}

function __create_virtual_keyboard_key(normal, shifted, width)
{
	var td = this.tr.appendChild(document.createElement('TD'));
	td.className="virtualKeyboardKey";
	td.down = false;
	td.key = normal;
	td.shifted = shifted;

	if (width) td.style.width=width;


	td.innerHTML = _html_(normal);
	if (shifted)
	{
		span = td.appendChild(document.createElement('span'));
		span.className= "virtualKeyboardKeyAlt";
		span.innerHTML = _html_(shifted);
	}

	td.addEventListener('mousedown',__virtual_keyboard_key_onmousedown);
	td.addEventListener('mouseup',__virtual_keyboard_key_onmouseup);
	td.addEventListener('mouseleave',__virtual_keyboard_key_onmouseup);
	td.addEventListener('touchstart',__virtual_keyboard_key_touchstart);
	td.addEventListener('touchcancel',__virtual_keyboard_key_onmouseup);
	td.addEventListener('touchend',__virtual_keyboard_key_onmouseup);

	td.setDown = __virtual_keyboard_key_set_down;
	td.setFixDown = __virtual_keyboard_key_set_fix_down;


	return td;
}


function __create_virtual_keyboard_row()
{
	var table = this.td.appendChild(document.createElement('TABLE'));
	table.cellSpacing=4;
	table.cellPadding=0;
	table.align="center";

	var tbody = table.appendChild(document.createElement('TBODY'));
	var tr = tbody.appendChild(document.createElement('TR'));
	table.tr = tr;

	table.addKey = __create_virtual_keyboard_key;
	return table;
}


function __virtual_keyboard_layout_show()
{
	for(var i=0; i < virtualKeyboard.layouts.length; i++)
	{
		if (this!=virtualKeyboard.layouts[i])
			virtualKeyboard.layouts[i].style.display = "none";
	}

	this.style.display="";


	if (virtualKeyboard.input)
	{
		if (virtualKeyboard.top===null || virtualKeyboard.top===undefined)
		{
			const keyboardHeight = 450;
			var r = virtualKeyboard.input.getBoundingClientRect();
            if (r.bottom > window.innerHeight - keyboardHeight)
            {
    	       	var y = r.top - keyboardHeight - 200;
    	       	if (y < 10) y = 10;
        	   	this.style.top = y;
			}	
			else
			{
				var y = r.bottom + 140;
				if (y > window.innerHeight - keyboardHeight) y = window.innerHeight - keyboardHeight;
				this.style.top = y;
			}
		}
		else
			this.style.top = virtualKeyboard.top;	
	}
            	

	virtualKeyboard.lastLayout = this;
	this.setShiftMode(false);
	this.setCapsLockMode(false);
}

function __virtual_keyboard_layout_set_shift_mode(onOff)
{
	if (this.lShiftKey) this.lShiftKey.setFixDown(onOff);
	if (this.rShiftKey) this.rShiftKey.setFixDown(onOff);
	virtualKeyboard.shiftMode = onOff;
}

function __virtual_keyboard_layout_set_caps_lock_mode(onOff)
{
    if (this.capsLockKey) this.capsLockKey.setFixDown(onOff);
    virtualKeyboard.capsLockMode = onOff;
}



function createVirtualKeybordLayout(layoutName)
{
	var layout = document.body.appendChild(document.createElement('TABLE'));
	virtualKeyboard.layouts.push(layout);
	layout.name = layoutName;

	layout.cellSpacing=0;
	layout.cellPadding=10;
	layout.style.position="fixed";
	layout.style.width = window.innerWidth - 10;
	layout.style.left = 4;
	layout.style.display="none";
	layout.style.zIndex=1000;
	layout.className="virtualKeyboard";

	var tbody = layout.appendChild(document.createElement('TBODY'));
	var tr = tbody.appendChild(document.createElement('TR'));
	var td = tr.appendChild(document.createElement('TD'));
    	

	layout.td = td;
	layout.addRow = __create_virtual_keyboard_row;
	layout.show = __virtual_keyboard_layout_show;
	layout.setShiftMode = __virtual_keyboard_layout_set_shift_mode;
	layout.setCapsLockMode = __virtual_keyboard_layout_set_caps_lock_mode;

	return layout;
}

function __input_on_focus_event()
{
	virtualKeyboard.input = this;
	var layoutName = 'ru';

	if (this.type == "email") layoutName = 'email';
	else
	if (this.dataset.type == "email") layoutName = 'email';
	else
	if (this.dataset.type == "name") layoutName = 'name';
	else
	if (this.dataset.type == "en") layoutName = 'en';
	else
	if (this.lang && this.lang.match(/en/)) layoutName = 'en';
	virtualKeyboard.show(true, layoutName);
}


virtualKeyboard = null;


class VirtualKeyboard
{
	constructor()
	{
		virtualKeyboard = this;


		this.input = null;	// редактируемый input
		this.top = null;	// верхняя координата появления виртуальной клавиатуры или null - авто

		this.layouts = [];	// раскладки. Есть отдельно ссылки на раскладки .ru,.en,.name,.email

		this.shiftMode = false;	// режим нажатой клавиши Shift
		this.capsLockMode = false; // режим нажатой клавиши Caps Lock

		this.visible = false;	// видна ли сейчас клавиатура. (readonly) см. метод show(...)



		//--------------- создаются раскладки -----------------
		var row;
		var layout;
		
		layout = createVirtualKeybordLayout('ru');
		this.ru = layout;
		
		row = layout.addRow();
		row.addKey('Ё');
		row.addKey('1','!');
		row.addKey('2','"');
		row.addKey('3','№');
		row.addKey('4',';');
		row.addKey('5','%');
		row.addKey('6',':');
		row.addKey('7','&');
		row.addKey('8','*');
		row.addKey('9','(');
		row.addKey('0',')');
		row.addKey('-','_');
		row.addKey('=','+');
		row.addKey('<=',null,longKeyWidth);

		row = layout.addRow();
		row.addKey('Й');
		row.addKey('Ц');
		row.addKey('У');
		row.addKey('К');
		row.addKey('Е');
		row.addKey('Н');
		row.addKey('Г');
		row.addKey('Ш');
		row.addKey('Щ');
		row.addKey('З');
		row.addKey('Х');
		row.addKey('Ъ');
		row.addKey('\\','/');


		row = layout.addRow();
		layout.capsLockKey = row.addKey('Caps Lock', null, longKeyWidth);
		row.addKey('Ф');
		row.addKey('Ы');
		row.addKey('В');
		row.addKey('А');
		row.addKey('П');
		row.addKey('Р');
		row.addKey('О');
		row.addKey('Л');
		row.addKey('Д');
		row.addKey('Ж');
		row.addKey('Э');

		row = layout.addRow();
		layout.lShiftKey = row.addKey('Shift', null, veryLongKeyWidth);
		row.addKey('Я');
		row.addKey('Ч');
		row.addKey('С');
		row.addKey('М');
		row.addKey('И');
		row.addKey('Т');
		row.addKey('Ь');
		row.addKey('Б');
		row.addKey('Ю');
		row.addKey(',');
		layout.rShiftKey = row.addKey('Shift', null, veryLongKeyWidth);

		row = layout.addRow();
		row.addKey('Eng', null, longKeyWidth);
		row.addKey(' ', null, spaceKeyWidth);
		row.addKey('@');
		row.addKey('Закрыть', null, longKeyWidth).key="close";
		this.lastLayout = layout;









		layout = createVirtualKeybordLayout('name');
		this.name = layout;
		
		row = layout.addRow();
		
		row.addKey('Й');
		row.addKey('Ц');
		row.addKey('У');
		row.addKey('К');
		row.addKey('Е');
		row.addKey('Н');
		row.addKey('Г');
		row.addKey('Ш');
		row.addKey('Щ');
		row.addKey('З');
		row.addKey('Х');
		row.addKey('Ъ');
		row.addKey('<=',null,longKeyWidth);


		row = layout.addRow();
		layout.capsLockKey = row.addKey('Caps Lock', null, longKeyWidth);
		row.addKey('Ф');
		row.addKey('Ы');
		row.addKey('В');
		row.addKey('А');
		row.addKey('П');
		row.addKey('Р');
		row.addKey('О');
		row.addKey('Л');
		row.addKey('Д');
		row.addKey('Ж');
		row.addKey('Э');

		row = layout.addRow();
		layout.lShiftKey = row.addKey('Shift', null, veryLongKeyWidth);
		row.addKey('Я');
		row.addKey('Ч');
		row.addKey('С');
		row.addKey('М');
		row.addKey('И');
		row.addKey('Т');
		row.addKey('Ь');
		row.addKey('Б');
		row.addKey('Ю');
		row.addKey('Ё');
		layout.rShiftKey = row.addKey('Shift', null, veryLongKeyWidth);

		row = layout.addRow();
		row.addKey(' ', null, spaceKeyWidth);
		row.addKey('Закрыть', null, longKeyWidth).key="close";




		layout = createVirtualKeybordLayout('en');
		this.en = layout;
		
		row = layout.addRow();
		row.addKey('`','~');
		row.addKey('1','!');
		row.addKey('2','@');
		row.addKey('3','#');
		row.addKey('4','$');
		row.addKey('5','%');
		row.addKey('6','^');
		row.addKey('7','&');
		row.addKey('8','*');
		row.addKey('9','(');
		row.addKey('0',')');
		row.addKey('-','_');
		row.addKey('=','+');
		row.addKey('<=',null,longKeyWidth);

		row = layout.addRow();
		row.addKey('Q');
		row.addKey('W');
		row.addKey('E');
		row.addKey('R');
		row.addKey('T');
		row.addKey('Y');
		row.addKey('U');
		row.addKey('I');
		row.addKey('O');
		row.addKey('P');
		row.addKey('[','{');
		row.addKey(']','}');
		row.addKey('\\','|');


		row = layout.addRow();
		layout.capsLockKey = row.addKey('Caps Lock', null, longKeyWidth);
		row.addKey('A');
		row.addKey('S');
		row.addKey('D');
		row.addKey('F');
		row.addKey('G');
		row.addKey('H');
		row.addKey('J');
		row.addKey('K');
		row.addKey('L');
		row.addKey(';');
		row.addKey('\'');

		row = layout.addRow();
		layout.lShiftKey = row.addKey('Shift', null, veryLongKeyWidth);
		row.addKey('Z');
		row.addKey('X');
		row.addKey('C');
		row.addKey('V');
		row.addKey('B');
		row.addKey('N');
		row.addKey('M');
		row.addKey(',','<');
		row.addKey('.','>');
		row.addKey('/','?');
		layout.rShiftKey = row.addKey('Shift', null, veryLongKeyWidth);

		row = layout.addRow();
		row.addKey('Рус', null, longKeyWidth);
		row.addKey(' ', null, spaceKeyWidth);
		row.addKey('@');
		row.addKey('Закрыть', null, longKeyWidth).key="close";





		layout = createVirtualKeybordLayout('email');
		this.email = layout;
		
		row = layout.addRow();
		row.addKey('~');
		row.addKey('1');
		row.addKey('2','@');
		row.addKey('3');
		row.addKey('4');
		row.addKey('5');
		row.addKey('6');
		row.addKey('7');
		row.addKey('8');
		row.addKey('9');
		row.addKey('0');
		row.addKey('-','_');
		row.addKey('<=',null,longKeyWidth);

		row = layout.addRow();
		row.addKey('Q');
		row.addKey('W');
		row.addKey('E');
		row.addKey('R');
		row.addKey('T');
		row.addKey('Y');
		row.addKey('U');
		row.addKey('I');
		row.addKey('O');
		row.addKey('P');


		row = layout.addRow();
		row.addKey('A');
		row.addKey('S');
		row.addKey('D');
		row.addKey('F');
		row.addKey('G');
		row.addKey('H');
		row.addKey('J');
		row.addKey('K');
		row.addKey('L');

		row = layout.addRow();
		layout.lShiftKey = row.addKey('Shift', null, veryLongKeyWidth);
		row.addKey('Z');
		row.addKey('X');
		row.addKey('C');
		row.addKey('V');
		row.addKey('B');
		row.addKey('N');
		row.addKey('M');
		row.addKey('.');
		layout.rShiftKey = row.addKey('Shift', null, veryLongKeyWidth);

		row = layout.addRow();
		row.addKey('@mail.ru');
		row.addKey('@gmail.com');
		row.addKey('@list.ru');
		row.addKey('@yandex.ru');
		row.addKey('@bk.ru');
		row.addKey('@');


		row.addKey('Закрыть', null, longKeyWidth).key="close";







		

		this.rescanInputs();
	}

	// внутренее событие нажатия клавивиши на виртуальной клавиатуре
	onKey(key)
	{
		if (!this.input) return;

		if (key.key=='close')
		{
			this.show(false);
			return;
		}

		if (key.key=="Shift")
		{
			this.lastLayout.setShiftMode(!this.shiftMode);
			return;
		}

		if (key.key=="Caps Lock")
		{
			this.lastLayout.setCapsLockMode(true);
			return;
		}

		if (key.key=="Рус")
		{
			this.ru.show();
			return;
		}

		if (key.key=="Eng")
		{
			this.en.show();
			return;
		}

		if (key.key=="<=")
		{
			if (this.input.selectionStart!=this.input.selectionEnd)
			{
				this.input.setRangeText(
                	 '',
	                 this.input.selectionStart,
    	             this.input.selectionEnd,
        	         'end');
			}
			else
			if (this.input.selectionStart > 0)
			{
				this.input.setRangeText(
                	 '',
	                 this.input.selectionStart-1,
    	             this.input.selectionStart,
        	         'end');
			}
			return;
		}


		var txt;
		if (this.shiftMode || this.capsLockMode)
		{
			if (key.shifted) txt = key.shifted; else txt = key.key;
		}
		else
		{
			txt = key.key.toLowerCase();
		}


		this.input.setRangeText(
            txt,
	        this.input.selectionStart,
    	    this.input.selectionStart,
        	'end');
        this.input.blur();
		this.input.focus();

		if (this.shiftMode) this.lastLayout.setShiftMode(false);

	}


	// показать клавитуру
	//   onOff - (bool) true - показать, false - спрятать
	//   layoutName - (string) опционально, название раскладки "ru","en","email","name"
	show(onOff, layoutName)
	{
		if (!onOff)
		{
			this.visible = false;
			for(var i=0; i < this.layouts.length; i++)	this.layouts[i].style.display="none";
			return;
		}

		if (this.visible)
		{
			if (this.lastLayout.name!=layoutName) this.visible = false;
		}

		if (!this.visible)
		{
			this.visible = true;
			for(var i=0; i < this.layouts.length; i++)
			{
				if (this.layouts[i].name == layoutName)
				{
					this.layouts[i].show();
					return;
				}
			}
			this.lastLayout.show();
		}	
	}

	// повторно сканировать все input и добавить им на событие onfocus действие появления виртуальной клавиатуры
	// У input-ов и textarea желательно определить:
	//       <input type=email...> (<--плохой вариант, появляется автозаполнение)
	//            или
	//       <input data-type=email...> для email
	//       <input data-type=name...> для ввода имен людей
	//       <input lang="en-xx"...> или <input data-type=en для ввода английских букв по умолчанию
	// Для textarea:
	//       <textarea data-type=email...>
	//       <textarea data-type=name...>
	//       <textarea data-type=en...>
	//       Для всех остальных клавиатура по умолчанию имеет русскую раскладку
	// метод вызывается в конструкторе виртуальной клавиатуры, поэтому
	// достаточно создать виртуальную клавиатуру после создания всех input-ов,
	// и тогда необходимость пересканирования input-ов отпадёт сама собой.
	rescanInputs()
	{
		function recourse(elm)
		{
			if ((elm.tagName == "INPUT" &&
				(elm.type=="" || elm.type=="text" || elm.type=="name" || elm.type=="email" || elm.type=="password" || elm.type=="search" || elm.type == "tel" || elm.type=="url")
				)
				||
				(elm.tagName == "TEXTAREA")
			)
			{
				elm.removeEventListener('focus',__input_on_focus_event);
				elm.removeEventListener('mousedown',__input_on_focus_event);
				elm.addEventListener('focus',__input_on_focus_event);
				elm.addEventListener('mousedown',__input_on_focus_event);
			}
			else
			{
				elm = elm.firstChild;
				while(elm)
				{
					recourse(elm);
					elm = elm.nextSibling;
				}
			}	
		}
		recourse(document.body);
	}
}


