// получить cookie с названием name
function getCookie(name, def)
{
  var matches = document.cookie.match(new RegExp(
    "(?:^|; )" + encodeURIComponent(name) + "=([^;]*)"
  ));
  return matches ? decodeURIComponent(matches[1]) : def;
}

function setCookie(name,value,days)
{
	if (!days) days = 3560;
    var expires = "";
    if (days)
    {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + (value || "")  + expires + "; path=/";
}


function strToInt(s,def)
{
	if (!def) def = 0;
	var n = parseInt(s);
	if (isNaN(n)) n = def;
	return n;
}

function strToFloat(s,def)
{
	if (!def) def = 0.0;
	var n = parseFloat(s);
	if (isNaN(n)) n = def;
	return n;
}

function floatToStr(n, digits)
{
	return n.toFixed(digits).replace(/\.0+^/);
}




function validateEmail(email)
{
  var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
  return re.test(email);
}


function detectMobile()
{
    const toMatch = [
        /Android/i,
        /webOS/i,
        /iPhone/i,
        /iPad/i,
        /iPod/i,
        /BlackBerry/i,
        /Windows Phone/i
    ];
    
    for(i=0; i < toMatch.length; i++)
    {
        if (navigator.userAgent.match(toMatch[i])) return true;
    }
    return false;
}



if (!String.prototype.replaceAll)
{
	String.prototype.replaceAll = function(search, replace){
	  return this.split(search).join(replace);
	}
}	

function _html_(s)
{
	if(s==="" || s===null || s===undefined) return "";
	return s.toString().replaceAll('&', '&amp;').replaceAll('<', '&lt;').replaceAll('>', '&gt;').replace(/\s\s/g,'&nbsp;&nbsp;');
}

function _html_br_(s)
{
	if(s==="" || s===null || s===undefined) return "";
	return s.toString().replaceAll('&', '&amp;').replaceAll('<', '&lt;').replaceAll('>', '&gt;').replace(/\r/g,'').replace(/\n/g,'<br>').replace(/\s\s/g,'&nbsp;&nbsp;');
}

function _cell_(s)
{
	if (s==='') return "&nbsp;";
	return s;
}	

function twoDigits(v)
{
	v = v.toString();
	if (v.length < 2) v = "0"+v;
	return v;
}



if (!String.prototype.trim) {
  (function() {
    // Вырезаем BOM и неразрывный пробел
    String.prototype.trim = function() {
      return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, '');
    };
  })();
}


function now()
{
	return parseInt((new Date()) / 1000);
}


function dateToStr(t)
{
	if (!t) t = new Date();
	else
	if (!(t instanceof Date))
	{
		t = new Date(t * 1000);
	}
	function z(s){return s.toString().length>1?s:'0'+s;}
	return z(t.getDate()) + "."+z(t.getMonth()+1)+"."+t.getFullYear();
}

function dateTimeToStr(t)
{
	if (!t) t = new Date();
	else
	if (!(t instanceof Date))
	{
		t = new Date(t * 1000);
	}	

	var m = t.getMinutes().toString();
	if (m.length == 1) m = "0"+m;
	
	return dateToStr(t)+" "+t.getHours()+":"+m;
}


function SQLtoDateStr(s)
{
	if (!s) return '';
	s = s.toString();
	var g = s.match(/(\d+)\-(\d+)\-(\d+)/);
	if (!g) return s;

	if (g[1] == '0000' || g[2]=='00' || g[3] == '00')
	{
		return '';
	}	

	var t = new Date();
	t.setFullYear(g[1]);
	t.setMonth(g[2]-1);
	t.setDate(g[3]);

	return getLocaleShortDateString(t);
}


function SQLtoTimeStr(s)
{
	if (!s) return '';
	s = s.toString();
	var g = s.match(/(\d+:\d+)/);
	if (!g) return '';
	return g[1];
}




function wordCase(n, case1, case2, case5)
{
	n = Math.abs(n);
	n%=100;
	if (parseInt(n / 10) == 1) n = 0;

	if (!case5) case5 = case2;

	switch(n % 10)
	{
		case 1: return case1;
		case 2:
		case 3:
		case 4: return case2;
		default: return case5;
	}
}


function createLoader()
{
	var loader = document.body.appendChild(document.createElement('DIV'));
	loader.className="lds-spinner";
	for(var i=0; i < 12; i++) loader.appendChild(document.createElement('DIV'));
	loader.close = function()
	{
		this.parentNode.removeChild(this);
	}
	return loader;
}



xhrInProgress = false;
function sendXHR(url, post, onLoad, onError, userData, timeout, showLoader, onProgress)
{
	if (!timeout) timeout = 12000;

	var xhr;
	if (window.XMLHttpRequest)
		xhr=new XMLHttpRequest();
	else
  		xhr=new ActiveXObject("Microsoft.XMLHTTP");

	xhr.onprogress = onProgress;
	xhr.timeout = timeout;
	xhr.userData = userData;
	xhr.onLoad = onLoad;
	xhr.onError = onError;

	if (onLoad && showLoader)
	{
		xhr.loader = createLoader();
		xhrInProgress = true;
	}	

	xhr.onreadystatechange=function()
		{
			if (this.readyState==4)
			{
				xhrInProgress = false;
				if (this.loader)
				{
					this.loader.close();
					this.loader=null;
				}

				if (this.status==200)
   				{
   					if (this.responseText.indexOf('ERROR:')==0)
   					{
   						if (this.onError) this.onError(this.responseText.substr(7), this.userData);
   					}	
   					else
   					if (this.responseText.indexOf('<!--error-->')==0 ||
   						this.responseText.indexOf('error</b>:')>0 ||
   						this.responseText.indexOf('<b>Notice</b>:')>0 ||
   						this.responseText.indexOf('Warning</b>:')>0)
   					{
   						if (this.onError) this.onError(this.responseText, this.userData);
   					}
   					else
   					{
   						if (this.onLoad) this.onLoad(this.responseText, this.userData);
					}
					return;
    			}
    			if (this.onError) this.onError("Невозможно отправить запрос на сервер!", this.userData);
			}
		};

	if (post)
	{
		xhr.open("POST", url, true);

		if (!(FormData && post instanceof FormData))
			xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		xhr.send(post);
	}
	else
	{
		xhr.open("GET", url, true);
		xhr.send();
	}
	return xhr;	
}