function PuzzleGame(imageFileName, imageWidth, imageHeight, colCount, rowCount, puzzleElement)
{
	var self = this;
	this.mainElement = puzzleElement;

	this.totalWidth = 1000;
	this.totalHeight = 650;
	this._margin = 20;

	this.mainElement.style.width=this.totalWidth;
	this.mainElement.style.height=this.totalHeight;
	this.mainElement.style.overflow="hidden";
	this.mainElement.style.backgroundImage="url('puzzle/puzzlebg.jpg')";
	this.mainElement.style.border="1px solid black";
	this.mainElement.draggable=false;
	this.mainElement.style.position = "relative";


	this.audio = document.createElement('audio');
	this.audio.src='puzzle/win.mp3';


	this.againBtn = new Image();
	this.mainElement.appendChild(this.againBtn);
	this.againBtn.style.position = "absolute";
	this.againBtn.style.width = 200;
	this.againBtn.style.height = 48;
	this.againBtn.src = "puzzle/puzzleagain.jpg";
	this.againBtn.style.left = (this.totalWidth - 200)/2;
	this.againBtn.style.top = this.totalHeight - 100;
	this.againBtn.style.display = "none";
	this.againBtn.draggable = false;
	this.againBtn.onmousedown = function()
		{
			this.style.left = (self.totalWidth - 200)/2 + 2;
			this.style.top = self.totalHeight - 100 + 2;
		};
	this.againBtn.onmouseup = function()
		{
			this.style.left = (self.totalWidth - 200)/2;
			this.style.top = self.totalHeight - 100;
			self.jumble();
		};
	this.againBtn.onmouseout = function()
		{
			this.style.left = (self.totalWidth - 200)/2;
			this.style.top = self.totalHeight - 100;
		};




	var w, h;
	w = imageWidth + colCount;
	h = imageHeight + rowCount;

	this.workField = document.createElement('canvas');
	this.mainElement.appendChild(this.workField);

	this.workField.style.position = "absolute";
	this.workField.style.left = (this.totalWidth - w)/2;
	this.workField.style.top = this._margin;
	this.workField.width = imageWidth + colCount + 1;
	this.workField.height = imageHeight + rowCount + 1;
	this.workField.draggable=false;

	this.puzzleW = imageWidth / colCount;
	this.puzzleH = imageHeight / rowCount;

	var context = this.workField.getContext('2d');
	context.strokeStyle = "white";
	context.fillStyle = "#978273";
	w = puzzleW+2;
	h = puzzleH+2;
	for(var row=0; row < rowCount; row++)
	for(var col=0; col < colCount; col++)
	{
		var x = col * puzzleW + col;
		var y = row * puzzleH + row;
		
		context.beginPath();
		context.moveTo(x,y);
		context.lineTo(x + w, y);
		context.lineTo(x + w, y + h);
		context.lineTo(x, y + h);
		context.closePath();
		context.fill();
		context.stroke();
	}


	this.currentPuzzle = null;
	this.puzzles = [];

	this.image = document.createElement('img');
	this.mainElement.appendChild(this.image);

	this.image.style.width = imageWidth;
	this.image.style.height = imageHeight;
	this.image.style.position = "absolute";
	this.image.style.left = (this.totalWidth - imageWidth)/2;
	this.image.style.top = this._margin + 1;
	this.image.style.display = "none";
	this.image.draggable=false;

	this.deleteAllPuzzles = function()
		{
			for(var i=0; i < this.puzzles.length; i++)
    		{
    			this.mainElement.removeChild(this.puzzles[i]);
    		}
    		this.puzzles=[];
		};

	this.slots = [];
	

    this.jumble = function()
    	{
    		this.deleteAllPuzzles();

    		this.image.style.display = "none";
    		this.workField.style.display = "";
    		this.againBtn.style.display = "none";


    		// создать слоты
    		this.slots = [];
    		var slotCount = 0;

    		var slotStepY = this.puzzleH + this.puzzleH / 8;
            
    		var x = this._margin + this.puzzleW / 2;
    		var y = this._margin + this.puzzleH / 2;

    		while(y < this.totalHeight - this.puzzleH / 2)
    		{
    			this.slots[slotCount++] = {x:x, y:y};
    			y+=slotStepY;
    		}

    		x = this.totalWidth - this._margin - this.puzzleW / 2;
    		y = this._margin + this.puzzleH / 2;
    		while(y < this.totalHeight - this.puzzleH / 2)
    		{
    			this.slots[slotCount++] = {x:x, y:y};
    			y+=slotStepY;
    		}

    		var lastCount = colCount * rowCount - slotCount;
    		if (lastCount > 0)
    		{
    			var slotStepX = (imageWidth + rowCount + rowCount * 10) / lastCount;
    			x = (this.totalWidth - (imageWidth + rowCount + rowCount * 10))/2 + this.puzzleW/2;
    			y = this._margin*2 + imageHeight + this.puzzleH / 2;

    			for(var i=0; i < lastCount; i++)
    			{
    				this.slots[slotCount++] = {x:x, y:y};
	    			x+=slotStepX;
    			}
			}


			// создать пазлы

			var x0 = (this.totalWidth - (imageWidth + rowCount)) / 2 + this.puzzleW/2;
			var y0 = this._margin + this.puzzleH/2 + 1;

			var inx=0;
			for(var row=0; row < rowCount; row++)
			for(var col=0; col < colCount; col++)
			{
				var canvas = document.createElement('canvas');
				this.mainElement.appendChild(canvas);

				canvas.width = this.puzzleW;
				canvas.height = this.puzzleH;

				x = col * this.puzzleW;
				y = row * this.puzzleH;

				canvas.place = {x: x0 + x + col, y: y0 + y + row};
				canvas.flyTo = null;

				var ok = true;
				do
				{
					var slotInx = parseInt(Math.random() * slotCount);
					if (slotInx == slotCount) slotInx--;

					canvas.slot = slotInx;

					ok = true;

					for(var i=0; i < inx; i++)
					{
						if (this.puzzles[i].slot == slotInx)
						{
							ok = false;
							break;
						}
					}
				} while(!ok);

				var ctx = canvas.getContext('2d');
				ctx.drawImage(this.image, x, y, this.puzzleW, this.puzzleH, 0, 0, this.puzzleW, this.puzzleH);

				canvas.style.position = "absolute";
				canvas.style.left = this.slots[ canvas.slot ].x - this.puzzleW/2;
				canvas.style.top = this.slots[ canvas.slot ].y - this.puzzleH/2;
				canvas.draggable = false;
				canvas.onmousedown = function()
					{
						if (this.slot==-1) return;
						this.style.border = "3px solid white";
						this.style.zIndex = 3;
						self.currentPuzzle = this;
						
					};
				canvas.addEventListener('touchstart', function(e)
					{
						if (this.slot==-1) return;
						this.style.border = "3px solid white";
						this.style.zIndex = 3;
						self.currentPuzzle = this;
					}, true);
				this.puzzles[inx++] = canvas;
			}
			this.currentPuzzle = null;
    	};
	this.image.onload = function() { self.jumble(); }
	this.image.src = imageFileName;

	document.body.doMouseMove = function(event)
		{
			if (!event) event = window.event;
			if (self.currentPuzzle)
			{
				var r = self.mainElement.getBoundingClientRect();
				var left = r.left + document.body.scrollLeft;
				var top = r.top + document.body.scrollTop;


				var x = event.pageX - left;
				var y = event.pageY - top;
				self.currentPuzzle.style.left = x - self.puzzleW/2;
				self.currentPuzzle.style.top = y - self.puzzleH/2;
			}
		};

	document.body.doMouseUp = function(event)
		{
			if (!event) event = window.event;
			if (self.currentPuzzle)
			{
				var r = self.mainElement.getBoundingClientRect();
				var left = r.left + document.body.scrollLeft;
				var top = r.top + document.body.scrollTop;


				var x = parseInt(self.currentPuzzle.style.left) + self.puzzleW/2;
				var y = parseInt(self.currentPuzzle.style.top) + self.puzzleH/2;

				self.currentPuzzle.flyFrom = {x:x, y:y};
				self.currentPuzzle.flyProgress = 0;
				self.currentPuzzle.style.zIndex = 2;
				
                if (Math.abs(x - self.currentPuzzle.place.x) < self.puzzleW/2 &&
                	Math.abs(y - self.currentPuzzle.place.y) < self.puzzleH/2)
                {
                	self.currentPuzzle.flyTo = self.currentPuzzle.place;
                	self.currentPuzzle.slot = -1;
                }
                else
                	self.currentPuzzle.flyTo = self.slots[ self.currentPuzzle.slot ];
                self.currentPuzzle.style.border = "";
                self.currentPuzzle = null;
			}
			
		};
    	
	document.body.addEventListener('mousemove', function(event)
		{
			document.body.doMouseMove(event);
		},true);
	document.body.addEventListener('mouseup', function(event)
		{
			document.body.doMouseUp(event);
		},true);


	document.body.addEventListener('touchmove', function(event)
		{
			document.body.doMouseMove(event.touches[0]);
		},true);
	document.body.addEventListener('touchend', function(event)
		{
			document.body.doMouseUp(event);
			event.preventDefault();
		},true);
	document.body.addEventListener('touchcancel', function(event)
		{
			document.body.doMouseUp(event);
			event.preventDefault();
		},true);


	this.endAnimProgress = 0;
	setInterval(function()
		{
			var flySteps = 16;
			var endAnimSteps = 16;

			if (this.endAnimProgress > 0)
			{
				var value;

				if (this.endAnimProgress < 3)
					value = 1.0 + 10 * this.endAnimProgress / 3;
				else
					value = 1.0 + (10 - 10 * (this.endAnimProgress - 3) / (endAnimSteps - 3));
				this.image.style.WebkitFilter ="brightness("+value+")";
				this.image.style.filter="brightness("+value+")";
				this.endAnimProgress++;
				if (this.endAnimProgress > endAnimSteps)
				{
					this.endAnimProgress = 0;
				}
			}

			for(var i=0; i < self.puzzles.length; i++)
			{
				if (self.puzzles[i].flyTo)
				{
					self.puzzles[i].flyProgress++;
					var lambda = self.puzzles[i].flyProgress / flySteps;
					var mu = 1.0 - lambda;
					var x = self.puzzles[i].flyTo.x * lambda + self.puzzles[i].flyFrom.x * mu;
					var y = self.puzzles[i].flyTo.y * lambda + self.puzzles[i].flyFrom.y * mu;

					self.puzzles[i].style.left = x - self.puzzleW/2;
					self.puzzles[i].style.top = y - self.puzzleH/2;

					if (self.puzzles[i].flyProgress>=flySteps)
					{
						self.puzzles[i].style.zIndex = 1;
						self.puzzles[i].flyTo = null;
						self.checkEnd();
					}
				}
			}
		},40);


	this.checkEnd = function()
		{
			for(var i=0; i < this.puzzles.length; i++)
			{
				if (this.puzzles[i].flyTo || this.puzzles[i].slot!=-1) return;
			}

			// игра окончена
			this.endAnimProgress = 1;
			this.deleteAllPuzzles();
			this.workField.style.display="none";
			this.image.style.display = "";
			this.image.style.WebkitFilter ="brightness(1)";
			this.image.style.filter="brightness(1)";
			this.againBtn.style.display = "";
			this.audio.play();
		};
}
