//------------ MainWebSocket --------------
mainWebSocketListeners = [];	// слушатели сообщений от mainWebSocket. onmessage(data)
function mainWebSocketSend(msg)
{
	if (mainWebSocket && mainWebSocket.readyState == 1)
		mainWebSocket.send(msg);
	else
	{
		mainWebSocketMessages.push(msg);
		mainWebSocketHistoryTimer = 1500;
	}	
};

function isMainWebSocketConnected()
{
	return mainWebSocket && mainWebSocket.readyState == 1;
}

onSpeechOver = null; // function()


window.addEventListener('blur', function() { window.focused=false; });
window.addEventListener('focus', function() { window.focused=true; });
window.focused = true;


mainWebSocket = null;	// веб-сокет управления. Отправка сообщений mainWebSocket.sendMessage(msg)

mainWebSocketReconnectTimer = 400;
mainWebSocketMessages = [];
mainWebSocketHistoryTimer = 0;
mainWebSocketEnabled = false;

function createMainWebSocket()
{
	mainWebSocketEnabled = true;
	if (mainWebSocket)
	{
		if(mainWebSocket.readyState == WebSocket.OPEN)
		{
			mainWebSocket.close();
			if (window.onConnection) window.onConnection(false);
		}	
	}	

	var url;
	if (location.hostname && location.hostname!='')
	{
		if (location.port!='')
			url = location.hostname+':'+location.port;
		else
			url = location.hostname;
	}
	else
		url = '127.0.0.1';

	mainWebSocketReconnectTimer = 3000;
	mainWebSocket = new WebSocket("ws://"+url+"/main");
	mainWebSocket.onclose = function(event)
  	{
  		mainWebSocket = null;
  		mainWebSocketReconnectTimer = 1;
  		if (window.onConnection) window.onConnection(false);
    };

    mainWebSocket.onopen = function(event)
    {
    	if (mainWebSocket == this)
    	{
    		mainWebSocketReconnectTimer = 0;
    		while(mainWebSocketMessages.length > 0)
    		{
    			if (this.readyState != 1)
    			{
    				mainWebSocketReconnectTimer = 1;
    				break;
    			}	
   				this.send(mainWebSocketMessages.shift());
    		}
    		if (window.onConnection) window.onConnection(true);

    	}	
    	else
    	{
    		this.close();
    		if (window.onConnection) window.onConnection(false);
    	}	
    };

    mainWebSocket.onmessage = function(event)
    	{
    		for(var i=0; i < mainWebSocketListeners.length; i++)
    		{
    			if (mainWebSocketListeners[i](event.data)) return;
    		}

    		var g;

    		g = event.data.match(/speech:state (\d+)/);
    		if (g)
    		{
    			isSpeaking = g[1]!=0;
    			if (!isSpeaking && onSpeechOver) onSpeechOver();
    			return;
			}


    		g = event.data.match(/url javascript\:\/\/([\d\D]*)/);
    		if (g)
    		{
    			eval(g[1]);
    			return;	
    		}

    		g = event.data.match(/url (.*)/);
    		if (g)
    		{
    			location=g[1];	
    		}


   		};	

    mainWebSocket.onerror = function(error)
    	{
    		if (mainWebSocket == this)
    		{
    			mainWebSocket.close();
    			mainWebSocket = null;
    			mainWebSocketReconnectTimer = 1;
    			if (window.onConnection) window.onConnection(false);
    		}	
		};
	
	
}



setInterval(function()
	{
		if (!mainWebSocketEnabled) return;

		if (mainWebSocketHistoryTimer > 0)
		{
			mainWebSocketHistoryTimer-=400;
			if (mainWebSocketHistoryTimer<=0)
			{
				mainWebSocketMessages = [];
			}
		}
		if (window.focused) 
		{
			if (mainWebSocketReconnectTimer > 0)
			{
				mainWebSocketReconnectTimer-=400;
				if (mainWebSocketReconnectTimer<=0)
				{
					createMainWebSocket();
				}
			}
		}	
		
	},400);


function sendToIScript(cmd)
{
	mainWebSocketSend("iscript:put "+cmd);	
}

function playSpeech(text)
{
	if (Array.isArray(text))
	{
		var n = parseInt(text.length * Math.random());
		if (n >= text.length) n = text.length - 1;
	    playSpeech(text[n]);
	    return;
	}

	mainWebSocketSend("say "+text);
}

speech_language = "RU";

function playSpeechLang(text)
{
	if (Array.isArray(text))
	{
		var n = parseInt(text.length * Math.random());
		if (n >= text.length) n = text.length - 1;
	    playSpeechLang(text[n]);
	    return;
	}

	mainWebSocketSend("say2 "+speech_language+" "+text);
}


isSpeaking = false;

