//------ UTF-8 ----------

document.write('<script src="std.js"></script>');
document.write('<script src="dynrobot.js"></script>');
document.write('<script src="virtualkeyboard.js"></script>');

document.write('<link rel="stylesheet" href="styles.css?1" type="text/css">');



autoReturn = false;
autoReturnPeriod = 60000;
autoReturnTimer = 0;


function createBackAndHome(backURL)
{
	autoReturn = true;
	if (!backURL) backURL = function() { playSpeech(''); history.back(); }
	backBtn = bigBtn(80,70,118,118,'backbtn.png', backURL);
	homeBtn = bigBtn(window.innerWidth - 80, 70, 126, 102, 'homebtn.png', function() { playSpeech(''); location = 'index.html'; });
}



canClickAgain = 0;
function __big_btn_do_click()
{
	if (canClickAgain>0) return;
	canClickAgain = 3;

	if (typeof this.onClick === "string")
	{
		location = this.onClick;
		return;
	}

	this.onClick();
}

function __big_btn_on_mouseDown()
{
	if (!this.disabled) this.isDown = true;
}

function __big_btn_on_mouseUp()
{
	this.isDown = false;
	this.doClick();
}

function __big_btn_on_mouseOut()
{
	this.isDown = false;
}

function __big_btn_on_touchStart(e)
{
	e.preventDefault();
	if (!this.disabled) this.isDown = true;
}

function __big_btn_on_touchCancel()
{
	this.isDown = false;
}

function __big_btn_on_touchEnd(e)
{
	e.preventDefault();
	this.isDown = false;
	if (!this.disabled) this.doClick();
	
}

function __big_btn_on_timer(dT)
{
	    	
	this.vibroTimer+=dT;
	if (this.vibroTimer>=this.vibroPhase && this.visible && !this.disabled)
	{
		this.innerOut = 0.03;

		var period = this.vibroPeriod;
		if (period == 0) period = this.parentNode.__bigBtnEnum * 2000 + 2000;
		this.vibroTimer-=period;
	}	

	

	var eps = 1.0 - this.scale;
	this.innerOut += (eps - this.innerOut) * dT / 300.0;
	this.scale += this.innerOut * 0.03 * dT;
	
	if (Math.abs(this.scale - 1.0) < 0.005 &&
		Math.abs(this.innerOut) < 0.005)
	{
		this.scale = 1.0;
		this.innerOut = 0.0;
	}

	if (this.isDown) this.scale = 0.95;
	
	this.style.transform='translate(-50%,-50%) scale('+this.scale+','+this.scale+')';

}

function __big_btn_destroy()
{
	if (this.bottomText) this.parentNode.removeChild(this.bottomText);
	for(var i=0; i < bigBtnList.length; i++)
	{
		if (bigBtnList[i]==this)
		{
			bigBtnList.splice(i,1);
			this.parentNode.__bigBtnEnum--;
			break;
		}
	}	
	this.parentNode.removeChild(this);
}



bigBtnList = [];
function deleteAllBigBtns()
{
	while(bigBtnList.length > 0) bigBtnList[0].destroy();
}

//----------------------------------------------
// Создает кнопку, которая будет поддергиваться 
// parent - HTML-элемент родитель
// centerX, centerY - экранные координаты центра кнопки (пикс)
// width, height - длина и ширина (пикс)
// img - имя файла (если строка) или указатель на HTML-элемент, который будет кнопкой
// onclick - ссылка на html-файл для перехода (если строка) или javascript
// bottomText - тект под кнопкой или null
function bigBtn2(parent, centerX, centerY, width, height, img, onclick, bottomText)
{
	if (!parent.__bigBtnEnum) parent.__bigBtnEnum = 0;

	if (typeof img === "string")
	{
		let src = img;
		img = new Image();
		img.src = src;
		parent.appendChild(img);
	}
	bigBtnList.push(img);

	img.onClick = onclick;
	img.doClick = __big_btn_do_click;

	if (bottomText)
	{
		img.bottomText = document.body.appendChild(document.createElement('CENTER'));
		img.bottomText.innerHTML = bottomText;
		img.bottomText.style.width = width;
		img.bottomText.style.whiteSpace="nowrap";
		img.bottomText.style.position = "absolute";
		img.bottomText.style.left = centerX - width/2;
		img.bottomText.style.top = centerY + height/2 + 10;
		img.bottomText.style.fontSize="32px";
	}



	img.style.position = "absolute";
	img.style.left = centerX;
	img.style.top = centerY;
	img.width = width;
	img.height = height;
	img.draggable = false;
	img.style.transform='translate(-50%,-50%)';

	
	// фаза моментов подёргивания (мс)
	img.vibroPhase = 2000 + (parent.__bigBtnEnum++) * 2000;

	// период моментов подёргивания (мс), если 0 - то авто
	img.vibroPeriod = 0;

	img.vibroTimer = 0;


	img.scale = 0.8;
	img.innerOut = 0.0;
	img.isDown = false;
		
		
	

	img.addEventListener('mousedown',__big_btn_on_mouseDown);
	img.addEventListener('mouseup',__big_btn_on_mouseUp);
	img.addEventListener('mouseout',__big_btn_on_mouseOut);
	img.addEventListener('touchstart',__big_btn_on_touchStart);
	img.addEventListener('touchcancel',__big_btn_on_touchCancel);
	img.addEventListener('touchend',__big_btn_on_touchEnd);
		

	Object.defineProperty(img, "visible",
		{
			get:function() { return this.style.display==""; },
			set:function(value)
				{
					if (value && !this.visible)	this.scale = 0.8;

					this.style.display = value ? "" : "none";
				}
		});
	Object.defineProperty(img, "x",
		{
			get:function() { return parseInt(this.style.left); },
			set:function(value)
			{
				this.style.left = value;
				if (this.bottomText) this.bottomText.style.left = value - this.width/2;
			}
		});
	Object.defineProperty(img, "y",
		{
			get:function() { return parseInt(this.style.top); },
			set:function(value) { this.style.top = value; }
		});

	img._disabled = false;

	Object.defineProperty(img, "disabled",
		{
			get:function() { return this._disabled; },
			set:function(value)
			{
				this.style.opacity = value ? 0.3 : 1.0;
				this._disabled=value;
				img.scale = 1.0;
				img.innerOut = 0.0;
				img.isDown = false;
			}
		});

	img.onTimer = __big_btn_on_timer;

	img.destroy = __big_btn_destroy;
	return img;
}

//----------------------------------------------
// Создает кнопку, которая будет поддергиваться 
// centerX, centerY - экранные координаты центра кнопки (пикс)
// width, height - длина и ширина (пикс)
// img - имя файла (если строка) или указатель на HTML-элемент, который будет кнопкой
// onclick - ссылка на html-файл для перехода (если строка) или javascript
// bottomText - тект под кнопкой или null
function bigBtn(centerX, centerY, width, height, img, onclick, bottomText)
{
	return bigBtn2(document.body, centerX, centerY, width, height, img, onclick, bottomText);
}	




function beginBtnCenter()
{
	center_btn_start_index = bigBtnList.length;
}

function endBtnCenter()
{
	var center_btn_end_index = bigBtnList.length - 1;

	var w = bigBtnList[center_btn_end_index].x - bigBtnList[center_btn_start_index].x;

	var x = (window.innerWidth - w)/2;

	var dX = x - bigBtnList[center_btn_start_index].x;

	for(var i=center_btn_start_index; i <= center_btn_end_index; i++)
	{
		bigBtnList[i].x+=dX;
	}
}



function createInput(type)
{
	var input = document.createElement('input');
	input.type = type;
	return input;
}	


function __null_func__(e) { e.preventDefault(); }
function __button_mouse_down__(e)
{
	if (this.className != "buttonActive") this.defClassName = this.className; else this.defClassName = '';

	if (e.preventDefault) e.preventDefault();
	if (this.disabled) return;
	this.className = "buttonActive";
}

function __button_mouse_up__(e)
{
	if (this.defClassName!==undefined) this.className = this.defClassName;
	this.click();
}

function __button_mouse_out__(e)
{
	if (this.defClassName!==undefined) this.className = this.defClassName;
}


function createButton()
{
	var button = document.createElement('button');
	button.oncontextmenu = __null_func__;
	button.addEventListener('mousedown',__button_mouse_down__);
	button.addEventListener('mouseup',__button_mouse_up__);
	button.addEventListener('mouseleave',__button_mouse_out__);
	button.addEventListener('touchstart',__button_mouse_down__);
	button.addEventListener('touchend',__button_mouse_up__);
	button.addEventListener('touchcancel',__button_mouse_out__);
	return button;
}


function createDialogBox(cssClass)
{
	var shadow = document.body.appendChild(document.createElement('div'));
	shadow.className="dialogShadow";

	var dlg = document.body.appendChild(document.createElement('div'));
	dlg.className = cssClass;
	dlg.shadow = shadow;

	dlg.close = function()
	{
		var saveAnimation = window.getComputedStyle(this).animation;
		var saveShadowAnimation = window.getComputedStyle(this.shadow).animation;

		this.style.animation = "none";
		this.shadow.style.animation = "none";
		this.offsetHeight;
		this.shadow.offsetHeight;

		// disable все кнопки
		var doDisable = function(elm)
		{
			if (elm.tagName == "BUTTON" ||
				elm.tagName == "INPUT" ||
				elm.tagName == "SELECT")
			{
				elm.disabled = true;
			}
			else
			{
				elm = elm.firstChild;
				while(elm)
				{
					doDisable(elm);
					elm = elm.nextSibling;
				}	
			}
		};

		doDisable(this);

		this.onanimationend=function()
		{
			document.body.removeChild(this);
			document.body.removeChild(this.shadow);
			this.shadow = null;
			if (this.onClose) this.onClose();
		};

		this.style.animation = saveAnimation
		this.style.animationDirection = "reverse";
		this.style.animationFillMode = "forwards";

		this.shadow.style.animation = saveShadowAnimation;
		this.shadow.style.animationDirection = "reverse";
		this.shadow.style.animationFillMode = "forwards";
	};
	return dlg;
}

function messageBox(html, cssClass, onClose)
{
	if (!cssClass) cssClass='messageBox';

	var dlg = createDialogBox(cssClass);
	dlg.onClose = onClose;

	var div = dlg.appendChild(document.createElement('CENTER'));
	div.style.width="100%";
	div.innerHTML = html;
	dlg.innerDIV = div;


	div = dlg.appendChild(document.createElement('CENTER'));
	div.style.marginTop = 50;
	div.style.marginBottom = 50;

	var btn = div.appendChild(createButton());
	btn.innerHTML = 'OK';
	btn.onclick = function()
	{
		dlg.close();
	};
	return dlg;
}

function errorBox(text, onclose)
{
	return messageBox(_html_(text), 'errorBox', onclose);
}


function __clear_btn_mouse_down__(e)
{
	if (e.preventDefault) e.preventDefault();
	this.src='cleardown.png';
}

function __clear_btn_mouse_up__(e)
{
	this.src='clear.png';
}	


function createEmailPanel(onclose)
{
	var dlg = createDialogBox('emailPanel');


	var centerDiv = dlg.appendChild(document.createElement('CENTER'));

	var div = centerDiv.appendChild(document.createElement('DIV'));
	div.style.width="80%";
	div.style.textAlign="left";
	

	var div2 = div.appendChild(document.createElement('DIV'));
	div2.style.marginBottom=20;
	div2.innerHTML = "Введите e-mail:";
	

	dlg.emailEditor = div.appendChild(createInput('text'));
	dlg.emailEditor.dataset.type="email";
	dlg.emailEditor.style.width="95%";
	dlg.emailEditor.autocomplete="off";
	var clearBtn = div.appendChild(new Image());
	clearBtn.src='clear.png';
	clearBtn.onclick=function() { dlg.emailEditor.value=''; }
	clearBtn.addEventListener('mousedown', __clear_btn_mouse_down__);
	clearBtn.addEventListener('mouseup', __clear_btn_mouse_up__);
	clearBtn.addEventListener('mouseleave', __clear_btn_mouse_up__);
	clearBtn.addEventListener('touchstart', __clear_btn_mouse_down__);
	clearBtn.addEventListener('touchend', __clear_btn_mouse_up__);
	clearBtn.addEventListener('touchcancel', __clear_btn_mouse_up__);


	div = dlg.appendChild(document.createElement('DIV'));
	div.style.marginTop=40;
	div.style.textAlign="center";


	var btn = div.appendChild(createButton());
	btn.innerHTML = 'Отмена';
	btn.className = "redbutton";
	btn.style.width=300;
	btn.style.marginRight=20;
	btn.onclick = function()
	{
		dlg.close();
		if (onclose) onclose();
	};

	

	btn = div.appendChild(createButton());
	btn.innerHTML = "Отправить";
	btn.className = "greenbutton";
	btn.style.marginLeft=20;
	btn.style.width=300;
	dlg.okBtn = btn;


	setTimeout(function()
		{
			emailPanel.emailEditor.blur();
			emailPanel.emailEditor.focus();

		},400);
	virtualKeyboard.top = 500;
	virtualKeyboard.rescanInputs();	

	return dlg;
}


screenPasswordActions = [];

function screenPasswordMouseDown(x,y)
{
	var screenWidth = window.innerWidth;
	var screenHeight = window.innerHeight;
	var zoneW = screenWidth / 6;

	var c = '0';
	if (x < zoneW && y < zoneW) c = '1';
	else
	if (x > screenWidth - zoneW && y < zoneW) c = '2';
	else
	if (x < zoneW && y > screenHeight - zoneW) c = '4';
	else
	if (x > screenWidth - zoneW && y > screenHeight - zoneW) c = '3';


	for(var i=0; i < screenPasswordActions.length; i++)
	{
		screenPasswordActions[i].onPress(c);
	}
}

class ScreenPasswordAction
{
	constructor(password, onAction)
	{
		this.onAction = onAction;
		this.password = password;
		this.enter = '';
		screenPasswordActions.push(this);
	}

	onPress(c)
	{
		this.enter+=c;
		if (this.password.substring(0,this.enter.length) != this.enter)
		{
			this.enter = c;
			if (this.password.substring(0,this.enter.length) != this.enter) this.enter = '';
		}	
		if (this.enter == this.password)
		{
			this.enter = '';
			this.onAction();
		}	
	}
}	



function __reset_auto_return_timer(e)
{
	screenPasswordMouseDown(e.clientX, e.clientY);

	autoReturnTimer = 0;
	sendToIScript("* CLICK");
}	

document.body.addEventListener('mousedown',__reset_auto_return_timer);






//document.body.addEventListener('touchstart',__reset_auto_return_timer);



document.addEventListener('DOMContentLoaded',
	function()
	{
		createMainWebSocket();
		sendToIScript("* URL "+location.href);
	});


setInterval(function(dT)
	{
		for(var i=0; i < bigBtnList.length; i++) bigBtnList[i].onTimer(dT);
		if (canClickAgain > 0) canClickAgain--;

		if (autoReturn)
		{
			autoReturnTimer+=dT;
			if (autoReturnTimer>=autoReturnPeriod)
			{
				location = "index.html";
			}
		}
	}, 40, 40);