colorLinesGameScale = 2.5;



// установить cookie с названием name в значение value
function setCookie(name, value)
{
	document.cookie = encodeURIComponent(name)+'='+encodeURIComponent(value)+'; SameSite=Lax; expires=Tue, 19 Jan 2038 03:14:07 GMT';
}

// получить cookie с названием name
function getCookie(name, def)
{
  var matches = document.cookie.match(new RegExp(
    "(?:^|; )" + encodeURIComponent(name) + "=([^;]*)"
  ));
  return matches ? decodeURIComponent(matches[1]) : def;
}




class ColorLines
{
	constructor(top, screenWidth)
	{
		this.path = "colorlines/";
		this.top = top;
		this.screenWidth = screenWidth;

		this.hiscore = parseInt(getCookie("colorLinesHiScore", "0"));


		// rules
		this.colCount = 8;
		this.rowCount = 8;
		this.firstBallCount = 5;
		this.secondBallCount = 4;
		this.minLineLength = 5;

		this.cellSize = 40*colorLinesGameScale;
		this.ballSize = 29*colorLinesGameScale;
		this.shadowSize = 36 * colorLinesGameScale;
		this.shadowOffset = 4 * colorLinesGameScale;

		this.creationInterval = 300;
		this.jumpPeriod = 800;
		this.movingInterval = 200;
		this.deletingInterval = 800;

		this.gameOverFlyInterval = 300;



		// ball file names
		this.ballFileNames = ['redball.png', 'greenball.png', 'blueball.png', 'maroonball.png', 'yellowball.png'];




	    // title
	    var img = document.body.appendChild(new Image());
	    img.src=this.path + "title.png";
	    img.width=720;
	    img.height=128;
	    img.draggable=false;
	    img.style.position="absolute";
	    img.style.left = (this.screenWidth - img.width)/2;
	    img.style.top = top;

	    this.cells = [];

	    // generate field
	    for(var j=0; j < this.rowCount; j++)
	    {
	    	this.cells[j] = [];
	    	for(var i=0; i < this.colCount; i++)
	    	{
	    		img = document.body.appendChild(new Image());
	    		img.src=this.path+'tile.jpg';
	    		img.draggable=false;
	    		img.width = this.cellSize;
	    		img.height = this.cellSize;
	    		img.style.position="absolute";
	    		img.style.left = this.getCellX(i);
	    		img.style.top = this.getCellY(j);
	    		img.col = i;
	    		img.row = j;
	    		img.game = this;

	    		img.addEventListener('mousedown', function() { this.game.onCellClick(this.col, this.row); }, false);
	    		img.addEventListener('touchstart', function(e) { this.game.onCellClick(this.col, this.row); }, true);

	    		this.cells[j][i] = {color:-1, mark:false, img:null, shadow:null};
	    	}
	    }

	    // generate points
	    this.scoreBlock = document.body.appendChild(document.createElement('DIV'));
	    this.scoreBlock.style.position="absolute";
	    this.scoreBlock.style.zIndex = 10;
	    this.scoreBlock.style.width=150;
	    this.scoreBlock.style.left = this.getCellX(this.colCount) + 5;
	    this.scoreBlock.style.top = this.getCellY(4);
	    this.scoreBlock.style.fontFamily="Arial";
	    this.scoreBlock.style.fontSize=20;
	    this.scoreBlock.style.color="#000000";
	    this.scoreBlock.innerHTML = "Счёт:";


	    this.score = 0;
	    
	    this.scoreLabel = this.scoreBlock.appendChild(document.createElement('DIV'));
	    this.scoreLabel.style.whiteSpacing="nowrap";
	    this.scoreLabel.style.width=150;
	    this.scoreLabel.style.fontSize=64;
	    this.scoreLabel.style.fontWeight="bold";
	    this.scoreLabel.style.color="#990044";
	    this.scoreLabel.innerHTML = "0";

	    this.hiscoreLabel = this.scoreBlock.appendChild(document.createElement('DIV'));
	    this.hiscoreLabel.style.whiteSpacing="nowrap";
	    this.hiscoreLabel.style.width=150;
	    this.hiscoreLabel.style.fontSize=20;
	    this.hiscoreLabel.style.fontWeight="bold";
	    this.hiscoreLabel.style.color="#000000";
	    this.hiscoreLabel.innerHTML = "Рекорд: "+this.hiscore;

	

	    this.gameOverImg = document.body.appendChild(new Image());
	    this.gameOverImg.src=this.path + "gameover.png";
	    this.gameOverImg.style.display="none";
	    this.gameOverImg.draggable=false;
	    this.gameOverImg.style.position = "absolute";
	    this.gameOverImg.style.zIndex = 10;

	    this.againBtn = document.body.appendChild(new Image());
	    this.againBtn.src=this.path + "again.jpg";
	    this.againBtn.style.display="none";
	    this.againBtn.draggable=false;
	    this.againBtn.style.position = "absolute";
	    this.againBtn.style.zIndex = 10;
	    this.againBtn.game = this;
	    this.againBtn.addEventListener("mousedown", function() { this.game.newGame(); }, false);
	    this.againBtn.addEventListener("touchstart", function() { this.game.newGame(); }, false);



	    this.stage = 0;
	    this.ballCount = this.firstBallCount;
	    this.stageTimer = 0;

	    this.audio = document.body.appendChild(document.createElement('AUDIO'));
	    this.audio.src=this.path + "jump.wav";
	    this.audio.load();



	    try
	    {
	    	PlaySpeech("Игра, цветные линии. Перемещая по полю шарики, нужно собрать линию одного цвета, не менее чем из пяти шариков. Можете приступать");
		}
		catch(e)
		{
		}


	    setInterval(
	    	function(self)
	    	{
	    		self.onTimer(20);
	    	}, 20, this);
	
		this.newGame();
	}

	playSound(sound)
	{
		this.audio.src=this.path + sound;
		this.audio.volume=0.3;
		this.audio.play();
	}




	getCellX(col)
	{
		return (this.screenWidth - this.rowCount * this.cellSize)/2 + col * this.cellSize;
	}

	getCellY(row)
	{
		return this.top + 132 + row * this.cellSize;
	}	

	newGame()
	{
		this.gameOverImg.style.display="none";

		for(var j=0; j < this.rowCount; j++)
		for(var i=0; i < this.colCount; i++)
		{
			this.removeBall(i,j);
		}
		this.score = 0;
		this.scoreLabel.innerHTML = this.score;
		this.stage = 0;
		this.ballCount = this.firstBallCount;
		this.stageTimer = 0;

		this.againBtn.style.display="none";

	}

	

	setBallCoords(col,row,z, xProgress, yProgress)
	{
		var cell = this.cells[row][col];
		var x = this.getCellX(col) + this.cellSize/2;
		var y = this.getCellY(row) + this.cellSize/2;

		if (xProgress) x+=this.cellSize * xProgress;
		if (yProgress) y+=this.cellSize * yProgress;


		if (z > 1.0)
		{
			var size = (2.0 - z) * this.ballSize;
			if (size < 1) size = 1;
			cell.img.style.left=x - size/2;
			cell.img.style.top=y - size/2;
			cell.img.width = size;
			cell.img.height = size;

			size = (2.0 - z) * this.shadowSize;
			if (size < 1) size = 1;

			x+=this.shadowOffset + z * 4;
			y+=this.shadowOffset + z * 4;

			cell.shadow.style.left=x - size/2;
			cell.shadow.style.top=y - size/2;
			cell.shadow.width = size;
			cell.shadow.height = size;
		}
		else
		if (z < 0.0)
		{
			var sizeX = (1.0 - 0.1 * z) * this.ballSize;
			var sizeY = (1.0 + 0.1 * z) * this.ballSize;

			y+=this.ballSize - sizeY;
			cell.img.style.left=x - sizeX/2;
			cell.img.style.top=y - sizeY/2;
			cell.img.width = sizeX;
			cell.img.height = sizeY;

			sizeX = (1.0 - 0.1 * z) * this.shadowSize;
			sizeY = (1.0 + 0.1 * z) * this.shadowSize;

			x+=this.shadowOffset;
			y+=this.shadowOffset;

			cell.shadow.style.left=x - sizeX/2;
			cell.shadow.style.top=y - sizeY/2;
			cell.shadow.width = sizeX;
			cell.shadow.height = sizeY;
		}
		else
		{
			cell.img.style.left=x - this.ballSize/2;
			cell.img.style.top=y - this.ballSize/2-z * 4;
			cell.img.width = this.ballSize;
			cell.img.height = this.ballSize;

			x+=this.shadowOffset+z * 4;
			y+=this.shadowOffset+z * 4;

			cell.shadow.style.left=x - this.shadowSize/2;
			cell.shadow.style.top=y - this.shadowSize/2;
			cell.shadow.width = this.shadowSize;
			cell.shadow.height = this.shadowSize;
		}
	}

	removeBall(col, row)
	{
		var cell = this.cells[row][col];
		if (cell.img)
		{
			document.body.removeChild(cell.img);
			cell.img = null;
		}
		if (cell.shadow)
		{
			document.body.removeChild(cell.shadow);
			cell.shadow = null;
		}
		cell.color = -1;
	}



	createBall(col, row, color)
	{
		this.removeBall(col, row);

		var cell = this.cells[row][col];
		cell.shadow = document.body.appendChild(new Image());
		cell.shadow.style.position = "absolute";
		cell.shadow.draggable=false;
		cell.shadow.style.zIndex = 2;
		cell.shadow.src=this.path+"shadow.png";
		cell.shadow.game = this;
		cell.shadow.col = col;
		cell.shadow.row = row;


		cell.shadow.addEventListener('mousedown', function() { this.game.onCellClick(this.col, this.row); }, false);
	    //cell.shadow.addEventListener('touchstart', function(e) { this.game.onCellClick(this.col, this.row); }, false);





		cell.img = document.body.appendChild(new Image());
		cell.img.style.position = "absolute";
		cell.img.draggable = false;
		cell.img.style.zIndex = 3;
		cell.img.src=this.path+this.ballFileNames[color];
		cell.img.game = this;
		cell.img.col = col;
		cell.img.row = row;

		cell.img.addEventListener('mousedown', function() { this.game.onCellClick(this.col, this.row); }, false);
	    //cell.img.addEventListener('touchstart', function(e) { this.game.onCellClick(this.col, this.row);}, false);




		cell.color = color;

		this.setBallCoords(col, row, 2);
	}

	getEmptyCellCount()
	{
		var n = 0;
		for(var j=0; j < this.rowCount; j++)
		{
			for(var i=0; i < this.colCount; i++)
				if (this.cells[j][i].color == -1) n++;	
		}
		return n;	
	}

	getRandomEmptyCell()
	{
		for(var k=0; k < 10000; k++)
		{
			var col = parseInt(this.colCount * Math.random());
			var row = parseInt(this.rowCount * Math.random());
			if (this.cells[row][col].color==-1)
			{
				return [col,row];
			}
		}
		return [0,0];
	}

	getWayTo(toCol, toRow)
	{
		var waves = [];
		var backs = [];
		for(var j=0; j < this.rowCount; j++)
		{
			waves[j] = [];
			backs[j] = [];
			for(var i=0; i < this.colCount; i++)
			{
				if (this.cells[j][i].color!=-1)
					backs[j][i] = 10;
				else
					backs[j][i] = 0;	
				waves[j][i] = 10000000;	
				
				
			}	
		}

		var col = toCol;
		var row = toRow;
		var w = 1;
		var b;

		waves[row][col] = 0;
		backs[row][col] = 5;
		
		while(true)
		{
			//--- prior
			if (col > this.selCol && backs[row][col-1]==0)
			{
				col--;
				backs[row][col] = 1;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (col < this.selCol && backs[row][col+1]==0)
			{
				col++;
				backs[row][col] = 2;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (row > this.selRow && backs[row-1][col]==0)
			{
				row--;
				backs[row][col] = 3;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (row < this.selRow && backs[row + 1][col]==0)
			{
				row++;
				backs[row][col] = 4;
				waves[row][col] = w;
				w++;
				continue;
			}





			//---- all
			if (col > 0 && backs[row][col-1]==0)
			{
				col--;
				backs[row][col] = 1;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (col < this.colCount - 1 && backs[row][col+1]==0)
			{
				col++;
				backs[row][col] = 2;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (row > 0 && backs[row-1][col]==0)
			{
				row--;
				backs[row][col] = 3;
				waves[row][col] = w;
				w++;
				continue;
			}

			if (row < this.rowCount - 1 && backs[row + 1][col]==0)
			{
				row++;
				backs[row][col] = 4;
				waves[row][col] = w;
				w++;
				continue;
			}

			b = backs[row][col];
			w--;

			if (b == 1)
			{
				col++;
				continue;
			}
			if (b == 2)
			{
				col--;
				continue;
			}
			if (b == 3)
			{
				row++;
				continue;
			}
			if (b == 4)
			{
				row--;
				continue;
			}
			break;
		}

		
		var way = [];

		col = this.selCol;
		row = this.selRow;

		w = waves[row][col];

		while(col!=toCol || row!=toRow)
		{
			b = 0;
			if (col > 0 && waves[row][col-1] < w)
			{
				b = 1;
				w = waves[row][col-1];
			}
			if (col < this.colCount - 1 && waves[row][col+1] < w)
			{
				b = 2;
				w = waves[row][col+1];
			}

			if (row > 0 && waves[row-1][col] < w)
			{
				b = 3;
				w = waves[row-1][col];
			}

			if (row < this.rowCount - 1 && waves[row+1][col] < w)
			{
				b = 4;
				w = waves[row+1][col];
			}

			switch(b)
			{
				case 0: return null;
				case 1: col--; break;
				case 2: col++; break;
				case 3: row--; break;
				case 4: row++; break;
			}
			way.push([col,row]);	
		}
		return way;
	}

	checkLines()
	{
		var ok = false;
		for(var j=0; j < this.rowCount; j++)
		{
			for(var i=0; i < this.colCount; i++)
			{
				this.cells[j][i].mark = false;
			}
		}

		
		for(var j=0; j < this.rowCount; j++)
		{
			for(var i=0; i < this.colCount; i++)
			{
				var color = this.cells[j][i].color;
				if (color!=-1)
				{
					var n = 0;
					for(var k = i; k < this.colCount; k++)
					{
						if (this.cells[j][k].color == color)
							n++;
						else
							break;
					}	
					if (n >= this.minLineLength)
					{
						ok = true;
						for(var k = i; k < this.colCount; k++)
						{
							if (this.cells[j][k].color == color)
								this.cells[j][k].mark = true;
							else
								break;
						}
					}

					n = 0;
					for(var k = j; k < this.rowCount; k++)
					{
						if (this.cells[k][i].color == color)
							n++;
						else
							break;
					}
					if (n >= this.minLineLength)
					{
						ok = true;
						for(var k = j; k < this.rowCount; k++)
						{
							if (this.cells[k][i].color == color)
								this.cells[k][i].mark = true;
							else
								break;
						}
					}

					n = 0;
					for(var k = j, q = i; q < this.colCount && k < this.rowCount; k++, q++)
					{
						if (this.cells[k][q].color == color)
							n++;
						else
							break;
					}	
					if (n >= this.minLineLength)
					{
						ok = true;
						for(var k = j, q = i; q < this.colCount && k < this.rowCount; k++, q++)
						{
							if (this.cells[k][q].color == color)
								this.cells[k][q].mark = true;
							else
								break;
						}	
					}

					n = 0;
					for(var k = j, q = i; q >= 0 && k < this.rowCount; k++, q--)
					{
						if (this.cells[k][q].color == color)
							n++;
						else
							break;
					}	
					if (n >= this.minLineLength)
					{
						ok = true;
						for(var k = j, q = i; q >=0 && k < this.rowCount; k++, q--)
						{
							if (this.cells[k][q].color == color)
								this.cells[k][q].mark = true;
							else
								break;
						}	
					}
				}	
			}
		}							
		return ok;
	}


	onCellClick(col, row)
	{
		if (this.stage==4)
		{
			if (this.cells[row][col].color==-1)
			{
				this.way = this.getWayTo(col,row);
				if (this.way)
				{
					this.stage = 5;
					this.stageTimer = 0;
				}
				else
				{
					this.playSound("wrong.mp3");
				}
				return;
			}
			else
			{
				this.stage = 3;
				this.setBallCoords(this.selCol,this.selRow,0);
				if (this.selCol == col && this.selRow == row) return;
			}	
		}
		if (this.stage==3)
		{
		    if (this.cells[row][col].color!=-1)
		    {
				this.selCol = col;
				this.selRow = row;
				this.stage = 4;
				this.stageTimer = 0;
			}
		}
	}

	onTimer(dT)
	{
		var prevStageTimer = this.stageTimer;

		this.stageTimer+=dT;
		switch(this.stage)
		{
			case 0:	// create ball
			{
				if (this.getEmptyCellCount() <=1)
				{
					// game over
					this.stage = 10;
					this.stageTimer = 0;


					if (this.score > this.hiscore)
					{
						setCookie("colorLinesHiScore", this.score);
						this.hiscore = this.score;
						this.hiscoreLabel.innerHTML = "Рекорд: "+this.hiscore;

						this.playSound("hiscore.mp3");
						try
						{
							PlaySpeech("Ура, >>вы побили рекорд.~ Поздравляю");
						}
						catch(e)
						{
						}	
					}
					else
					{
						this.playSound("gameover.mp3");
					}	
					return;
				}
						
				var c = this.getRandomEmptyCell();
				this.selCol = c[0];
				this.selRow = c[1];
				this.createBall(c[0],c[1], parseInt(this.ballFileNames.length * Math.random()));
				this.stage = 1;
				this.stageTimer = 0;
				this.ballCount--;
				return;
			}	
			case 1:
			{
				// put down ball
				var z = 2.0 - 2.0 * this.stageTimer/this.creationInterval;
				if (z < 0) z = 0.0;
				this.setBallCoords(this.selCol, this.selRow, z);
				if (this.stageTimer >= this.creationInterval)
				{
					if (this.ballCount <= 0)
					{
						if (this.checkLines())
						{
							this.stage = 2;
							this.playSound("deleting.mp3");
						}	
						else
							this.stage = 3; // 3
						this.stageTimer = 0;
					}
					else
					{
						this.stage = 0;
						this.stageTimer = 0;
					}
				}
				return;	
			}

			case 2:	// delete lines
			{
				var z = 2.0 * this.stageTimer / this.deletingInterval;
				for(var j=0; j < this.rowCount; j++)
				{
					for(var i=0; i < this.colCount; i++)
					{
						if (this.cells[j][i].mark)
							this.setBallCoords(i,j,z);
					}
				}
				if (this.stageTimer>=this.deletingInterval)
				{
				    var n = 0;
					for(var j=0; j < this.rowCount; j++)
					{
						for(var i=0; i < this.colCount; i++)
						{
							if (this.cells[j][i].mark)
							{
								n++;
								this.removeBall(i,j);
							}	
						}
					}

					this.score+=n;
					this.scoreLabel.innerHTML = this.score;

					this.stage = 3;
					this.stageTimer = 0;
				}
				return;
			}

			case 4:	// jumping
			{
				var z = Math.sin(this.stageTimer * Math.PI * 2.0 / this.jumpPeriod);
				this.setBallCoords(this.selCol, this.selRow, z);

				/*
				if (this.stageTimer >= this.jumpPeriod/2 &&
					prevStageTimer < this.jumpPeriod/2)
				{
					
					this.playSound("jump.wav");
				}
				*/
				return;	
			}

			case 5: // moving
			{	
				var z = Math.sin(this.stageTimer * Math.PI * 2.0 / this.movingInterval);
				
				var toCol = this.way[0][0];
				var toRow = this.way[0][1];

				var dCol = toCol - this.selCol;
				var dRow = toRow - this.selRow;

				if (this.stageTimer >= this.movingInterval/2 && 
					prevStageTimer < this.movingInterval/2)
				{
					this.playSound("jump.wav");
				}	

				if (z > 0)
				{
					dCol *= this.stageTimer/(this.movingInterval/2);
					dRow *= this.stageTimer/(this.movingInterval/2);
				}
				this.setBallCoords(this.selCol, this.selRow,z,dCol,dRow);

				if (this.stageTimer>=this.movingInterval)
				{
					this.stageTimer = 0;
					this.cells[toRow][toCol] = this.cells[this.selRow][this.selCol];
					this.cells[toRow][toCol].img.col = toCol;
					this.cells[toRow][toCol].img.row = toRow;
					this.cells[toRow][toCol].shadow.col = toCol;
					this.cells[toRow][toCol].shadow.row = toRow;

					this.cells[this.selRow][this.selCol] = {color:-1, mark:false, img:null, shadow:null};
					this.selCol = toCol;
					this.selRow = toRow;

					this.way.splice(0,1);
					if (this.way.length == 0)
					{
						if (this.checkLines())
						{
							this.stage = 2;
							this.playSound("deleting.mp3");
							return;
						}
						else
						{
							this.stage = 0;
							this.stageTimer = 0;
							this.ballCount = this.secondBallCount;
						}
					}
				}
				return;
			}

			case 10:
			{
				var x = this.screenWidth / 2;
				var y = 132 + this.top + this.rowCount * this.cellSize / 2 - 80;

				var defW = this.gameOverImg.naturalWidth;
				var defH = this.gameOverImg.naturalHeight;

				var w = defW * this.stageTimer / this.gameOverFlyInterval;
				var h = defH * this.stageTimer / this.gameOverFlyInterval;

				if (w == 0) w = 1;
				if (h == 0) h = 1;
				if (w > defW) w = defW;
				if (h > defH) h = defH;

				this.gameOverImg.style.display="";
				this.gameOverImg.style.top = y - h / 2;
				this.gameOverImg.style.left = x - w / 2;
				this.gameOverImg.width = w;
				this.gameOverImg.height = h;

				if (this.stageTimer >= this.gameOverFlyInterval)
				{
					this.stageTimer = 0;
					this.stage = 11;
				}	
				return;
			}

			case 11:
			{
				var x = this.screenWidth / 2;
				var y = 132 + this.top + this.rowCount * this.cellSize / 2 + 80;

				var defW = this.againBtn.naturalWidth;
				var defH = this.againBtn.naturalHeight;

				var w = defW * this.stageTimer / this.gameOverFlyInterval;
				var h = defH * this.stageTimer / this.gameOverFlyInterval;

				if (w == 0) w = 1;
				if (h == 0) h = 1;
				if (w > defW) w = defW;
				if (h > defH) h = defH;

				this.againBtn.style.display="";
				this.againBtn.style.top = y - h / 2;
				this.againBtn.style.left = x - w / 2;
				this.againBtn.width = w;
				this.againBtn.height = h;

				if (this.stageTimer >= this.gameOverFlyInterval)
				{
					this.stageTimer = 0;
					this.stage = 12;
				}	
				return;
				
			}

		}
	}
}	